/*jslint node: true, nomen: true, unparam: true */
/*global jquery, _, $, define, navigator, window */

'use strict';

define(['jquery', 'backbone', 'marionette', 'underscore', 'handlebars', 'async', 'core/models/Resources', 'core/models/UserSession', 'core/models/Staff', 'core/models/Patient', 'core/models/PackageData'],
    function ($, Backbone, Marionette, _, Handlebars, async, Resources, UserSession, Staff, Patient, PackageData) {
        var Portal, baseUrl;

        Portal = new Backbone.Marionette.Application();

        baseUrl = $('#app-loader').attr("src");
        baseUrl = baseUrl ? baseUrl.split('/'): '';
        Portal.baseUrl = baseUrl[1] ? baseUrl[0] + '/': '';
        
        Portal.uber = false; // By Default
        Portal.widgets = []; // By Default

        Portal.addRegions({
            head: "head",
            containerRegion: "#portal-container",
            infobarRegion: "#portal-infobar",
            infobarSubRegion: "#portal-subjectbar",
            infobarFooterRegion: "#portal-infobar-footer",
            panelRegion: "#portal-panel",
            userMenuRegion: "#user-menu-window",
            //subheadingRegion: added in Controller,
            alertsListRegion: "#alerts-list-window",
            errorRegion: "#error",
            modalRegion: "#portal-modal"
        });

        Portal.on('initialize:before', function () {
            return undefined;
        });

        Portal.addInitializer(function () {
            return undefined;
        });

        Portal.on('initialize:after', function () {
            return undefined;
        });

        // Allow routers to route after Portal and applets are loaded
        Portal.on('start', function () {
            Backbone.history.start();
        });

        Portal.mobile = (function () {
            var userAgent = navigator.userAgent || navigator.vendor || window.opera;
            return ((/iPhone|iPod|iPad|Android|BlackBerry|Opera Mini|IEMobile/).test(userAgent));
        }());

        // Applet-exposed resources should be put here
        Portal.resources = function () {
            return Resources.instance();
        };
        Portal.userSession = function () {
            return UserSession.instance();
        };
        Portal.staff = function () {
            return Staff.instance();
        };
        Portal.patient = function () {
            return Patient.instance();
        };
        Portal.packageData = function () {
            return PackageData.instance();
        };

        return Portal;
    });